import { tassign } from 'tassign';
import {
  CLEAR_CONCEPTS,
  SET_CURRENT_CONCEPT_SELECTED,
  FETCHING_CONCEPTS,
  FETCH_CONCEPTS,
  INITIALIZE_CONCEPT_SEARCH_META_DATA,
  UPDATE_CONCEPT_SEARCH_META_DATA,
  SET_CONCEPT_SEARCH_LAST_BUTTON,
  SET_CONCEPT_SEARCH_NEXT_BUTTON,
  SET_CONCEPT_SEARCH_PREVIOUS_BUTTON,
  SET_CONCEPT_SEARCH_FIRST_BUTTON,
  RESET_CONCEPT_SEARCH_BUTTONS,
} from '../actions';

function initConceptSearchMetaData(state, action) {
  return tassign(state, {conceptSearchData: action.payload});
}

function updateConceptSearchMetaData(state, action) {
  return tassign(state, {conceptSearchData: {...state.conceptSearchData, ...action.payload}});
}

function setConceptSearchLastButton(state, action) {
  return tassign(state, {canConceptSearchLastButton: action.payload});
}

function setConceptSearchPreviousButton(state, action) {
  return tassign(state, {canConceptSearchPreviousButton: action.payload});
}

function setConceptSearchNextButton(state, action) {
  return tassign(state, {canConceptSearchNextButton: action.payload});
}

function setConceptSearchFirstButton(state, action) {
  return tassign(state, {canConceptSearchFirstButton: action.payload});
}

function resetConceptSearchButtons(state, action) {
  return tassign(state, {
    canConceptSearchLastButton: true,
    canConceptSearchFirstButton: false,
    canConceptSearchNextButton: true,
    canConceptSearchPreviousButton: false});
}

function clearConcepts(state, action) {
  return tassign(state, {
    searched: false,
    concepts: []
  });
}

function fetchingConcepts(state, action) {
  return tassign(state, {
    searched: false,
    searching: true
  });
}

function fetchConcepts(state, action) {
  return tassign(state, {
    searched: true,
    searching: false,
    concepts: action.payload
  });  
}

function setCurrentConceptSelected(state, action) {
  return tassign(state, {selectedConcept: action.payload})
}

const INITIAL_STATE = {
  concepts: [],
  searched: false,
  searching: false,
  selectedConcept: {},
  conceptSearchData: {},
  maxConceptSearchPages: 10,
  canConceptSearchLastButton: true,
  canConceptSearchFirstButton: false,
  canConceptSearchNextButton: true,
  canConceptSearchPreviousButton: false,
}

export default function conceptSearchReducer(state = INITIAL_STATE, action) {
  switch (action.type) {
    case SET_CURRENT_CONCEPT_SELECTED:
      return setCurrentConceptSelected(state, action);
    case CLEAR_CONCEPTS:
      return clearConcepts(state, action);
    case FETCHING_CONCEPTS:
      return fetchingConcepts(state, action);
    case FETCH_CONCEPTS:
      return fetchConcepts(state, action);
    case INITIALIZE_CONCEPT_SEARCH_META_DATA:
      return initConceptSearchMetaData(state, action);
    case UPDATE_CONCEPT_SEARCH_META_DATA:
      return updateConceptSearchMetaData(state, action);
    case SET_CONCEPT_SEARCH_LAST_BUTTON:
      return setConceptSearchLastButton(state, action);
    case SET_CONCEPT_SEARCH_NEXT_BUTTON:
      return setConceptSearchNextButton(state, action);
    case SET_CONCEPT_SEARCH_PREVIOUS_BUTTON:
      return setConceptSearchPreviousButton(state, action);
    case SET_CONCEPT_SEARCH_FIRST_BUTTON:
      return setConceptSearchFirstButton(state, action);
    case RESET_CONCEPT_SEARCH_BUTTONS:
      return resetConceptSearchButtons(state, action);
  }
  return state;
}